string GetDescription()
{
	return "Creates a simple punk rock style drum sequence";
}

void DoFootAndSnare(RenderPart @p)
{
	double step = 1.0;
	
	if (p.GetTempo() < 120) step /= 2.0;
	
	bool type = true;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{		
			if ( type )
			{
			 	if (RndInt(0,2) != 0 || (m < step))
			 	{
				 	p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 36, 127);
			 		if (RndInt(0,2) != 0) p.AddPercNote(CreateTime(i,m+step/2), CreateTime(i,m + step/2 +0.1), 36, 127);
		 		}
		 		else
		 		{
			 		p.AddPercNote(CreateTime(i,m+step/2), CreateTime(i,m + step/2 +0.1), 36, 127);
		 		}
			}
			else
			{
				p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 38, 118);
			 	if (RndInt(0,2) != 0) p.AddPercNote(CreateTime(i,m+step/2), CreateTime(i,m + step/2 +0.1), 36, 127);
			}
			
			if (type) type = false;
			else type = true;
		}
	}
}

void DoChorusHiHat(RenderPart @p, int pit)
{
	double step = 0.5;
	if (p.GetTempo() < 120) step /= 2.0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{		
			if (i % 2 == 0) 
			{
				if ( m < step)
				{
					if (RndInt(0,1) == 0) p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 57, 125);	
					else p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 49, 125);	
				}
				else p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), pit, RndInt(95,105));
			}
			else
			{
				if ( m+step >= p.GetUniquePart().GetMetrum() && RndInt(0,1) == 0)
				{
					if (RndInt(0,1) == 0) p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 57, 118);	
					else p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 49, 118);	
				}
				else p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), pit, RndInt(95,105));
			}
		}
	}
}

void DoIntroHiHat(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 120) step /= 2.0;
		
	int bars = 4;
	if (RndInt(0,1) == 0) bars = 2;
	if (RndInt(0,2) == 0) bars = 1;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		if (i % bars == 0)
		{
			p.AddPercNote(CreateTime(i,-step/2.0), CreateTime(i,-(step/2.0) + 0.1), 46, 111);	
		}
		
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{		
			p.AddPercNote(CreateTime(i,m), CreateTime(i,m + 0.1), 42, RndInt(109,113));
		}
	}
}

void DoTransition(RenderPart @p)
{
	double step = 0.25;
	if (p.GetTempo() < 100) step /= 2.0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		double start = RndInt(0,1) * step * 2;
		
		p.AddPercNote(CreateTime(i, start), CreateTime(i, start+ 0.1), 36, 127);		
		p.AddPercNote(CreateTime(i, p.GetUniquePart().GetMetrum()/2), CreateTime(i, p.GetUniquePart().GetMetrum()/2 + 0.1), 36, 127);	
		p.AddPercNote(CreateTime(i, p.GetUniquePart().GetMetrum()-step*2), CreateTime(i, p.GetUniquePart().GetMetrum()-step*2 + 0.1), 36, 127);	
		
		if (RndInt(0,4) != 0) p.AddPercNote(CreateTime(i, start), CreateTime(i, start+ 0.1), 58, 117);		
		if (RndInt(0,4) != 0) p.AddPercNote(CreateTime(i, p.GetUniquePart().GetMetrum()/2), CreateTime(i, p.GetUniquePart().GetMetrum()/2 + 0.1), 49, 111);	
		if (RndInt(0,4) != 0) p.AddPercNote(CreateTime(i, p.GetUniquePart().GetMetrum()-step*2), CreateTime(i, p.GetUniquePart().GetMetrum()-step*2 + 0.1), 58, 117);	
		
		for (double m = start + RndInt(1,2)*step; m < p.GetUniquePart().GetMetrum()/2 ; m+=step)
			p.AddPercNote(CreateTime(i, m), CreateTime(i, m + 0.1), 38, RndInt(108,115));		
		
		if (i == p.GetEndBar()-1)
		{
			int n = 0;
			
			for (double m = p.GetUniquePart().GetMetrum()/2 + step*RndInt(0,2) ; m < p.GetUniquePart().GetMetrum()-step*RndInt(0,1) ; m+=step)
			{
				if (RndInt(0,5) != 0) 
				{
					p.AddPercNote(CreateTime(i, m), CreateTime(i, m + 0.1), 47-n*2, RndInt(108,115));		
					if (n < 3 && RndInt(0,1) == 0) n++;
				}
			}	
		}
		else
		{
			if (RndInt(0,1) == 0)
			{
				for (double m = p.GetUniquePart().GetMetrum()/2 + step*2 ; m < p.GetUniquePart().GetMetrum()-step*RndInt(0,2) ; m+=step)
				{
					p.AddPercNote(CreateTime(i, m), CreateTime(i, m + 0.1), 38, RndInt(108,115));		
				}			
			}
			else
			{
				bool type = false;
				if (RndInt(0,1) == 0) type = true;
				for (double m = p.GetUniquePart().GetMetrum()/2 + step*2 ; m < p.GetUniquePart().GetMetrum()-step*RndInt(0,2) ; m+=step*2)
				{
					if (type) 
					{
						p.AddPercNote(CreateTime(i, m), CreateTime(i, m + 0.1), 38, RndInt(108,115));		
						p.AddPercNote(CreateTime(i, m+step), CreateTime(i, m+ step + 0.1), 38, RndInt(108,115));		
						type = false;
					}
					else 
					{
						type = true;
						p.AddPercNote(CreateTime(i, m), CreateTime(i, m + 0.1), 45, 127);		
					}
				}
			}	
		}
	}
}


void Render(RenderPart @p)
{
	if (p.GetParam("foot & snare").toInt() > 0) DoFootAndSnare(p);
	if (p.GetParam("chorus hi-hat").toInt() > 0) DoChorusHiHat(p, 46);
	if (p.GetParam("verse hi-hat").toInt() > 0) DoChorusHiHat(p, 51);
	if (p.GetParam("intro hi-hat").toInt() > 0) DoIntroHiHat(p);
	if (p.GetParam("transition").toInt() > 0) DoTransition(p);
	
}